/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.param;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.param.InstallConfigResolverException;
import oracle.ops.verification.framework.util.VerificationUtil;

public final class InstallConfigResolver
implements VerificationAPIConstants {
    private static String IVAR_OCR_LOCATIONS = "OCR_LOCATIONS";
    private static String IVAR_VOTING_LOCATIONS = "VOTING_DISKS";
    private static String IVAR_ORACLE_BASE = "ORACLE_BASE";
    private static String IVAR_ORACLE_HOME = "ORACLE_HOME";
    private static String IVAR_CONFIGURE_GNS = "GNS_CONF";
    private static String IVAR_GNS_DOMAIN_NAME = "GNS_DOMAIN_LIST";
    private static String IVAR_GNS_VIP_ADDRESS = "GNS_ADDR_LIST";
    private static String IVAR_INTERCONNECT_LIST = "NETWORKS";
    private static String IVAR_HOST_VIP_NAMES = "CRS_NODEVIPS";
    private static String IVAR_RAC_HOME = "ORACLE_HOME";
    private static String IVAR_ASM_HOME = "ORACLE_HOME";
    private static String IVAR_DBA_GROUP = "ORA_DBA_GROUP";
    private static String IVAR_ASM_GROUP = "ORA_ASM_GROUP";
    private static String IVAR_INSTALL_USER = "ORACLE_OWNER";
    private static String IVAR_HA_HOME = "ORACLE_HOME";
    private static String IVAR_ASM_DISKGROUP_DISKS = "ASM_DISKS";
    private static String IVAR_ASM_DISK_DISCOVERY_STRING = "ASM_DISCOVERY_STRING";
    private static String IVAR_NODE_NAME_LIST = "NODE_NAME_LIST";
    private Map<String, Set<String>> m_mapInstToCVUVars = new HashMap<String, Set<String>>();
    private static MessageBundle m_msgBundle = VerificationUtil.getMessageBundle("Prvp");

    public InstallConfigResolver() {
        this.mapInstToCVUVars(IVAR_OCR_LOCATIONS, "OCR_LOCATIONS");
        this.mapInstToCVUVars(IVAR_VOTING_LOCATIONS, "VOTING_LOCATIONS");
        this.mapInstToCVUVars(IVAR_ORACLE_BASE, "ORACLE_BASE");
        this.mapInstToCVUVars(IVAR_ORACLE_HOME, "ORACLE_HOME");
        this.mapInstToCVUVars(IVAR_CONFIGURE_GNS, "CONFIGURE_GNS");
        this.mapInstToCVUVars(IVAR_GNS_DOMAIN_NAME, "GNS_SUB_DOMAIN");
        this.mapInstToCVUVars(IVAR_GNS_VIP_ADDRESS, "GNS_VIP_ADDRESS");
        this.mapInstToCVUVars(IVAR_INTERCONNECT_LIST, "INTERCONNECT_LIST");
        this.mapInstToCVUVars(IVAR_HOST_VIP_NAMES, "HOST_VIP_NAMES");
        this.mapInstToCVUVars(IVAR_RAC_HOME, "RAC_HOME");
        this.mapInstToCVUVars(IVAR_ASM_HOME, "ASM_HOME");
        this.mapInstToCVUVars(IVAR_DBA_GROUP, "DBA_GROUP");
        this.mapInstToCVUVars(IVAR_ASM_GROUP, "ASM_GROUP");
        this.mapInstToCVUVars(IVAR_INSTALL_USER, "INSTALL_USER");
        this.mapInstToCVUVars(IVAR_HA_HOME, "HA_HOME");
        this.mapInstToCVUVars(IVAR_ASM_DISKGROUP_DISKS, "ASM_DISKGROUP_DISKS");
        this.mapInstToCVUVars(IVAR_ASM_DISK_DISCOVERY_STRING, "ASM_DISK_DISCOVERY_STRING");
        this.mapInstToCVUVars(IVAR_NODE_NAME_LIST, "NODE_NAME_LIST");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void resolve(String instalConfigFile, List resolvedVar, List unresolvedVar) throws InstallConfigResolverException {
        p = new Properties();
        ex /* !! */  = null;
        try {
            p.load(new FileInputStream(instalConfigFile));
            ** if (ex /* !! */  == null) goto lbl-1000
        }
        catch (FileNotFoundException fex) {
            Trace.out((String)("FileNotFoundException while loading the properties. msg:" + fex.getMessage()));
            ex /* !! */  = fex;
            ** if (ex /* !! */  == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                errMsg = InstallConfigResolver.m_msgBundle.getMessage("1044", true, (Object[])new String[]{instalConfigFile});
                throw new InstallConfigResolverException(errMsg, ex /* !! */ );
            }
lbl-1000:
            // 1 sources

            {
            }
        }
        catch (IOException iex) {
            Trace.out((String)("IOException while loading the properties. msg:" + iex.getMessage()));
            ex /* !! */  = iex;
            ** if (ex /* !! */  == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                errMsg = InstallConfigResolver.m_msgBundle.getMessage("1044", true, (Object[])new String[]{instalConfigFile});
                throw new InstallConfigResolverException(errMsg, ex /* !! */ );
            }
lbl-1000:
            // 1 sources

            {
            }
            {
                catch (Throwable var7_12) {
                    if (ex /* !! */  != null) {
                        errMsg = InstallConfigResolver.m_msgBundle.getMessage("1044", true, (Object[])new String[]{instalConfigFile});
                        throw new InstallConfigResolverException(errMsg, ex /* !! */ );
                    }
                    throw var7_12;
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            errMsg = InstallConfigResolver.m_msgBundle.getMessage("1044", true, (Object[])new String[]{instalConfigFile});
            throw new InstallConfigResolverException(errMsg, ex /* !! */ );
        }
lbl-1000:
        // 1 sources

        {
        }
        e = p.propertyNames();
        while (e.hasMoreElements()) {
            instalVar = (String)e.nextElement();
            instalVal = p.getProperty(instalVar);
            Trace.out((String)("got instalVar:" + instalVar));
            Trace.out((String)("got instalVal:" + instalVal));
            if (instalVar == null && instalVar.length() == 0) continue;
            if (instalVal == null) {
                Trace.out((String)("Install Var:" + instalVar + " does not have any value"));
                continue;
            }
            len = instalVal.length();
            if (len > 1 && instalVal.charAt(0) == '\'' && instalVal.charAt(len - 1) == '\'') {
                instalVal = instalVal.substring(1, len - 1);
            }
            if (instalVal.length() == 0) {
                Trace.out((String)("Instal Var:" + instalVar + " does not have any value"));
                if (unresolvedVar == null) continue;
                unresolvedVar.add(instalVar);
                continue;
            }
            cvuVars = this.getAllCVUVars(instalVar);
            if (cvuVars == null) {
                Trace.out((String)("Instal Var:" + instalVar + " does not have associated CVU var"));
                if (unresolvedVar != null) {
                    unresolvedVar.add(instalVar);
                }
                Trace.out((String)("treating " + instalVar + " as CVU variable as it is"));
                VerificationUtil.setVariableValue(instalVar, instalVal);
                continue;
            }
            if (resolvedVar != null) {
                resolvedVar.add(instalVar);
            }
            for (String cvuVar : cvuVars) {
                Trace.out((String)("Instal Var:" + instalVar + " is resolved to CVU var:" + cvuVar));
                cvuVal = this.convertToCVUVal(cvuVar, instalVal);
                Trace.out((String)("setting CVU var:" + cvuVar + " value:" + cvuVal));
                VerificationUtil.setVariableValue(cvuVar, cvuVal);
            }
        }
    }

    public void clean() {
        this.m_mapInstToCVUVars.clear();
    }

    private void mapInstToCVUVars(String instalVar, String cvuVar) {
        Set<Object> setCVUVars = null;
        setCVUVars = this.m_mapInstToCVUVars.containsKey(instalVar) ? this.m_mapInstToCVUVars.get(instalVar) : new HashSet();
        this.m_mapInstToCVUVars.put(instalVar, setCVUVars);
        setCVUVars.add(cvuVar);
    }

    private Set<String> getAllCVUVars(String instVar) {
        return this.m_mapInstToCVUVars.get(instVar);
    }

    private String convertToCVUVal(String cvuVar, String instVal) {
        String cvuVal = null;
        Trace.out((String)("Entry: instVal=" + instVal + ", cvuVar=" + cvuVar));
        if (cvuVar.equals("HOST_VIP_NAMES")) {
            StringBuffer strBufCvuVal = new StringBuffer();
            String[] instVips = instVal.split(",");
            for (int i = 0; i < instVips.length; ++i) {
                Trace.out((String)("Convering instVip:" + instVips[i]));
                String[] instVip = instVips[i].split("/");
                if (strBufCvuVal.length() > 0) {
                    strBufCvuVal.append(',');
                }
                if (instVip.length != 3) {
                    Trace.out((String)("Error: instVips=[" + instVips[i] + "] is not in valid format. it cannot be converted to CVU val"));
                    continue;
                }
                String node = null;
                node = instVip[0].endsWith("-vip") ? instVip[0].substring(0, instVip[0].indexOf("-vip")) : instVip[0];
                strBufCvuVal.append(node);
                strBufCvuVal.append(":");
                strBufCvuVal.append(instVip[0]);
            }
            cvuVal = strBufCvuVal.toString();
        } else {
            cvuVal = cvuVar.equals("INTERCONNECT_LIST") ? instVal.replaceFirst("/", ":") : instVal;
        }
        Trace.out((String)("returning cvuVar:" + cvuVal));
        return cvuVal;
    }
}

